<?php namespace Visiosoft\PatronModule\Mizan\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Illuminate\Database\Eloquent\Builder;

class MizanTableBuilder extends TableBuilder
{

    public function onQuerying(Builder $query)
    {
        $query->orderBy("date","desc");
    }
    // we use custom filters
    //    protected $filters = [
    //        'date'
    //    ];

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'hesap_kodu' => 'ASC',
        ]
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
