<?php namespace Visiosoft\PatronModule\Http\Controller\Admin;

use Carbon\Carbon;
use Visiosoft\PatronModule\Analytic\Contract\AnalyticRepositoryInterface;
use Visiosoft\PatronModule\Expense\Contract\ExpenseRepositoryInterface;
use Visiosoft\PatronModule\Expense\Form\ExpenseFormBuilder;
use Visiosoft\PatronModule\Expense\Table\ExpenseTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ExpensesController extends AdminController
{

    /**
     * @var ExpenseRepositoryInterface
     */
    private $expenseRepository;
    /**
     * @var AnalyticRepositoryInterface
     */
    private $analyticRepository;

    public function __construct(
        ExpenseRepositoryInterface $expenseRepository,
        AnalyticRepositoryInterface $analyticRepository
    )
    {
        parent::__construct();
        $this->expenseRepository = $expenseRepository;
        $this->analyticRepository = $analyticRepository;
    }

    /**
     * Display an index of existing entries.
     *
     * @param ExpenseTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ExpenseTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ExpenseFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ExpenseFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ExpenseFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ExpenseFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * View an existing entry analytics.
     *
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Illuminate\Contracts\Container\BindingResolutionException
     */
    public function viewAnalytics($id)
    {
        $mainExpense = $this->expenseRepository->find($id);
        $expenses = $this->expenseRepository->newQuery()
            ->where('item_id', $mainExpense->item_id)
            ->where('date', '>', Carbon::now()->submonths(3))
            ->get()
            ->groupBy(function($date) {
                return Carbon::parse($date->date)->format('m');
            });

        $analytics = array();
        foreach ($expenses as $month => $expense) {
            $analytic = $this->analyticRepository->findAllBy('expense_id', $expense[0]->id);
            if (count($analytic)) {
                $analytics[] = [
                    'expense' => $expense[0],
                    'analytics' => $analytic
                ];
            } else {
                unset($expenses[$month]);
            }
        }

        $this->template->set('show_banner', true);

        return $this->view->make(
            'module::admin/expenses/view-analytics', [
                'analytics'  => $analytics,
            ]
        );
    }
}
