<?php namespace Visiosoft\PatronModule\Debt\Form;


use Visiosoft\PatronModule\Debt\DebtModel;

class DebtFormFields
{
    public function handle(DebtFormBuilder $builder, DebtModel $debtModel)
    {
        $entry = $builder->getFormEntry();

        $type = ($entry->type) ? $entry->type : request('type');

        $fields = [
            'company',
            'type' => [
                'value' => request('type'),
            ],
            'price',
            'currency',
            'expiry_date'
        ];

        $assignments = $debtModel->getAssignments();
        $fields_assign = $assignments->notLocked()->fieldSlugs();

        $remove_slug = 'debt';
        if ($type == 'debt') {
            $remove_slug = 'receivable';
        }

        $debt_category_key = array_search($remove_slug . '_category', $fields_assign);

        unset($fields_assign[$debt_category_key]);
        $builder->setFields(array_merge($fields, $fields_assign));
    }
}
