<?php namespace Visiosoft\PatronModule\Analytic\Form;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Visiosoft\PatronModule\Expense\Contract\ExpenseRepositoryInterface;

class ExpenseOptions
{

    public function handle(RelationshipFieldType $fieldType, ExpenseRepositoryInterface $entries) {
        $fieldType->setOptions(
            $entries->newQuery()
                ->join('patron_items','patron_items.id','=','patron_expenses.item_id')
                ->selectRaw("CONCAT_WS('', default_patron_items.name, ' - ', DATE_FORMAT(default_patron_expenses.date, '%M %Y')) AS expense_value, default_patron_expenses.id")
                ->pluck('expense_value', 'id')
                ->toArray()
        );
    }
}
