<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePatronCreateReferenceValues extends Migration
{
    protected $stream = [
        'slug' => 'companies',
    ];

    protected $fields = [
        'cari_oran_reference_value' => [
            'type' => 'anomaly.field_type.text',
            'config' => [
                'default_value' => "1.00",
            ],
        ],
        'likidite_oran_reference_value' => [
            'type' => 'anomaly.field_type.text',
            'config' => [
                'default_value' => "0.70",
            ],
        ],
        'nakit_orani_reference_value' => [
            'type' => 'anomaly.field_type.text',
            'config' => [
                'default_value' => "0.25",
            ],
        ],
        'alacak_tahsil_reference_value' => [
            'type' => 'anomaly.field_type.text',
            'config' => [
                'default_value' => "60.00",
            ],
        ],
        'borc_odeme_reference_value' => [
            'type' => 'anomaly.field_type.text',
            'config' => [
                'default_value' => "75.00",
            ],
        ],
        'stokta_tutma_reference_value' => [
            'type' => 'anomaly.field_type.text',
            'config' => [
                'default_value' => "90.00",
            ],
        ],
        'nakde_donusum_reference_value' => [
            'type' => 'anomaly.field_type.text',
            'config' => [
                'default_value' => "70.00",
            ],
        ],
    ];

    protected $assignments = [
        'cari_oran_reference_value',
        'likidite_oran_reference_value',
        'nakit_orani_reference_value',
        'alacak_tahsil_reference_value',
        'borc_odeme_reference_value',
        'stokta_tutma_reference_value',
        'nakde_donusum_reference_value',
    ];
}
