<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePatronCreateExpensesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'expenses',
        'title_column' => 'item_id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'item' => [
            'required' => true,
        ],
        'total' => [
            'required' => true,
        ],
        'date' => [
            'required' => true,
        ],
    ];

}
