<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePatronCreatePatronFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'slug' => [
            'type' => 'anomaly.field_type.slug',
            'config' => [
                'slugify' => 'name',
                'type' => '_'
            ],
        ],
        'phone' => 'anomaly.field_type.text',
        'tax_number' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'separator' => '',
            ]
        ],
        "users" => [
            "type"   => "anomaly.field_type.multiple",
            "config" => [
                "related" => \Anomaly\UsersModule\User\UserModel::class,
            ]
        ],
        "item" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\PatronModule\Item\ItemModel::class,
                "mode"    => "search",
            ]
        ],
        'total' => [
            'type' => 'visiosoft.field_type.integer'
        ],
        "date" => [
            "type"   => "anomaly.field_type.datetime",
            "config" => [
                "mode"          => "date",
            ]
        ],
        "expense" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related"    => \Visiosoft\PatronModule\Expense\ExpenseModel::class,
                "mode"       => "search",
                "handler"    => "Visiosoft\PatronModule\Analytic\Form\ExpenseOptions@handle",
            ]
        ],
        'entity_count' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'separator' => '',
            ]
        ],
        'entity_name' => 'anomaly.field_type.text',
        "operator" => [
            "type"   => "anomaly.field_type.select",
            "config" => [
                "options"       => [
                    '/' => 'visiosoft.module.patron::field.division',
                    '*' => 'visiosoft.module.patron::field.multiplication',
                    '+' => 'visiosoft.module.patron::field.addition',
                    '-' => 'visiosoft.module.patron::field.subtraction',
                ],
                "default_value" => '/',
            ]
        ],
        "synonym" => "anomaly.field_type.text"
    ];

}
