<?php namespace Visiosoft\PatronModule\Mizan;

use Visiosoft\PatronModule\Mizan\Contract\MizanRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class MizanRepository extends EntryRepository implements MizanRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var MizanModel
     */
    protected $model;

    /**
     * Create a new MizanRepository instance.
     *
     * @param MizanModel $model
     */
    public function __construct(MizanModel $model)
    {
        $this->model = $model;
    }

    public function createNew($name, $hesap_kodu, $total, $date, $company_id)
    {
        return $this->create([
            'name' => $name,
            'hesap_kodu' => $hesap_kodu,
            'total' => $total,
            'real_value' => $total,
            'date' => $date,
            'company_id' => $company_id,
        ]);
    }
}
