<?php namespace Visiosoft\PatronModule\Mizan\Form;


use Visiosoft\PatronModule\CodeNote\Contract\CodeNoteRepositoryInterface;

class MizanFormFields
{
    public function handle(MizanFormBuilder $builder)
    {
        $entry = $builder->getFormEntry();

        if ($entry->countChild() > 0) {
            $fields = ['note', 'reduction_note'];
        } else {
            $fields = [
                'hesap_kodu'   => [
                    'label'        => 'Hesap Kodu',
                    'readonly'        => true
                ],
                'name'         => [
                    'label'        => 'Hesap Adı',
                    'readonly'        => true
                ],
                'total' => [
                 'label'        => 'Tutar',
                ],
                'real_value' => [
                    'label'        => 'Hesap Değerleme İlkeleri ve Açıklamalar',
                    'instructions' => function (CodeNoteRepositoryInterface $codeNoteRepository) use ($entry) {
                        if ($entry) {
                            $hesap_kodu = explode('.', $entry->hesap_kodu);
                            if ($code_note = $codeNoteRepository->newQuery()->where('mizan_hesap_kodu', array_first($hesap_kodu))->first()) {
                                return $code_note->mizan_hesap_note."<br/> <b> Gerçek Tutar </b> ";
                            }
                        }
                    }
                ],
                'reduction_note',
                'note',
            ];
        }

       if($builder->getFormMode() !== "edit"){
           $fields = array_merge($fields,['date', 'company',]);
       }
        $builder->setFields($fields);
    }
}
