<?php namespace Visiosoft\PatronModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\IncomeModule\Income\Contract\IncomeRepositoryInterface;
use Visiosoft\PatronModule\Traits\PatronTrait;

class SalesController extends ResourceController
{

    use PatronTrait;

    protected $incomeRepository;

    public function __construct(IncomeRepositoryInterface $incomeRepository)
    {
        $this->incomeRepository = $incomeRepository;
        parent::__construct();
    }

    public function salesManagement()
    {
        if ($company = $this->getActiveCompany()) {
            $details = $this->incomeRepository->getSalesByCompanyId($company->getId());
        }
        return $this->view->make('module::sales', compact('details'));
    }
}
