<?php namespace Visiosoft\PatronModule\Http\Controller\Admin;

use Visiosoft\PatronModule\Mizan\Form\MizanFormBuilder;
use Visiosoft\PatronModule\Mizan\Table\MizanTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class MizanController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param MizanTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(MizanTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param MizanFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(MizanFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param MizanFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(MizanFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
