<?php namespace Visiosoft\ParasutModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\OrdersModule\Orderdetail\Event\PaymentOrder;
use Visiosoft\ParasutModule\Invoice\Contract\InvoiceRepositoryInterface;
use Visiosoft\ParasutModule\Invoice\InvoiceRepository;
use Anomaly\Streams\Platform\Model\Parasut\ParasutInvoicesEntryModel;
use Visiosoft\ParasutModule\Invoice\InvoiceModel;

class ParasutModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/parasut'           => 'Visiosoft\ParasutModule\Http\Controller\Admin\InvoicesController@index',
        'admin/parasut/create'    => 'Visiosoft\ParasutModule\Http\Controller\Admin\InvoicesController@create',
        'admin/parasut/edit/{id}' => 'Visiosoft\ParasutModule\Http\Controller\Admin\InvoicesController@edit',
    ];

    protected $listeners = [
        PaymentOrder::class => [
            \Visiosoft\ParasutModule\Invoice\Listeners\PaymentOrder::class,
        ],
    ];

    protected $bindings = [
        ParasutInvoicesEntryModel::class => InvoiceModel::class,
    ];

    protected $singletons = [
        InvoiceRepositoryInterface::class => InvoiceRepository::class,
    ];
}
