<?php namespace Visiosoft\PaddleModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\PaddleModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\PaddleModule\Subscription\Event\SiteCreatedWithPaddle;
use Visiosoft\PaddleModule\Subscription\Event\SiteCreateWithPaddle;
use Visiosoft\PaddleModule\Subscription\Event\SubscriptionCreateWithPaddle;
use Visiosoft\PaddleModule\Subscription\SubscriptionRepository;
use Anomaly\Streams\Platform\Model\Paddle\PaddleSubscriptionEntryModel;
use Visiosoft\PaddleModule\Subscription\SubscriptionModel;
use Illuminate\Routing\Router;
use Visiosoft\SiteModule\Site\Listener\newSiteWithPaddle;
use Visiosoft\SubscriptionsModule\Subscription\Listener\createdSiteWithPaddle;
use Visiosoft\SubscriptionsModule\Subscription\Listener\newSubscriptionWithPaddle;

class PaddleModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
//        'admin/paddle'           => 'Visiosoft\PaddleModule\Http\Controller\Admin\SubscriptionController@index',
//        'admin/paddle/create'    => 'Visiosoft\PaddleModule\Http\Controller\Admin\SubscriptionController@create',
//        'admin/paddle/edit/{id}' => 'Visiosoft\PaddleModule\Http\Controller\Admin\SubscriptionController@edit',
        'webhook/subscription/create' => 'Visiosoft\PaddleModule\Http\Controller\SubscriptionController@create',

    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\PaddleModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\PaddleModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        SubscriptionCreateWithPaddle::class => [
            newSubscriptionWithPaddle::class
        ],
        SiteCreateWithPaddle::class => [
            newSiteWithPaddle::class
        ],
        SiteCreatedWithPaddle::class => [
            createdSiteWithPaddle::class
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\PaddleModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        PaddleSubscriptionEntryModel::class => SubscriptionModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        SubscriptionRepositoryInterface::class => SubscriptionRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
