<?php namespace Visiosoft\PaddleModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\PaddleModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\PaddleModule\Subscription\Event\SiteCreatedWithPaddle;
use Visiosoft\PaddleModule\Subscription\Event\SiteCreateWithPaddle;
use Visiosoft\PaddleModule\Subscription\Event\SubscriptionCreateWithPaddle;

class SubscriptionController extends ResourceController
{
    private $subscription;

    public function __construct(SubscriptionRepositoryInterface $subscription)
    {
        $this->subscription = $subscription;
        parent::__construct();
    }

    public function create()
    {
        if (isset($this->request->alert_name) and $this->request->status == "active") {
            $save_callback = fopen('../public/paddle' . now()->format('Y-m-d_H-i-s') . '.json', 'w');
            fwrite($save_callback, json_encode($this->request->all()));
            fclose($save_callback);

            $passthroughParameters = $this->request->passthrough;
            $passthroughParameters = str_replace('\'', '"', $passthroughParameters);
            $passthroughParameters = json_decode($passthroughParameters, true);


            $paddle = $this->subscription->create([
                'paddle_response' => json_encode($this->request->all()),
                'email' => $passthroughParameters['email'],
                'name' => $passthroughParameters['name_surname'],
                'subdomain' => $passthroughParameters['subdomain'],
            ]);

            $subscription = event(new SubscriptionCreateWithPaddle($paddle));
            if (array_first(array_first($subscription))) {
                $subscription = array_first($subscription)['relation'];
                $site = event(new SiteCreateWithPaddle($paddle));
                if (array_first(array_first($site))) {
                    $site = array_first($site)['relation'];
                    event(new SiteCreatedWithPaddle($site, $subscription));
                    return response()->json(['status' => 'success']);
                }
            } else {
                return response()->json(['status' => 'error', 'message' => 'Subscription işlemi sırasında bir hata oluştu.']);
            }

        }
    }

}
