<?php namespace Visiosoft\PackagesModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Illuminate\Http\Request;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryModel;
use Visiosoft\PackagesModule\User\Form\UserFormBuilder;
use Visiosoft\PackagesModule\User\Table\UserTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\PackagesModule\User\UserModel;
use Visiosoft\PackagesModule\Userentry\UserentryModel;

class UsersController extends AdminController
{

    public function index(UserTableBuilder $table)
    {
        $table->addButtons([
            'approve' => [
                'type' => function (EntryInterface $entry) {
                    if ($entry->status == "in_cart") {
                        return "info";
                    } else {
                        return "success";
                    }
                },
                'icon' => function (EntryInterface $entry) {
                    if ($entry->status == "in_cart") {
                        return "fa fa-spinner";
                    } else {
                        return "fa fa-check";
                    }
                },
                'href' => 'admin/packages/users/{entry.id}',
                'text' => function (EntryInterface $entry) {
                    if ($entry->status == "approved") {
                        return trans('visiosoft.module.packages::field.approved.name');
                    } else if ($entry->status == "pending") {
                        return trans('visiosoft.module.packages::field.approve.name');
                    } else {
                        return trans('visiosoft.module.packages::field.in_cart.name');
                    }
                },
                'disabled' => function (EntryInterface $entry) {
                    if ($entry->status == "approved" or $entry->status == "in_cart") {
                        return true;
                    }
                }
            ]
        ]);
        return $table->render();
    }

    public function create(UserFormBuilder $form, Request $request, PackageEntryModel $packageEntryModel, UserentryModel $userentryModel)
    {
        if ($request->action == "save") {
            $Packageentry = $packageEntryModel->getEntryPackage($request->package);
            $userentryModel->addEntryUserArray($Packageentry);
        }
        return $form->render();
    }

    public function edit(UserFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function approve(PackageModel $packageModel, $id)
    {
        $packageModel->ApprovedStatus($id);
        return $this->redirect->back()->withSuccess([trans('visiosoft.module.packages::message.package_defined')]);
    }
}
