<?php namespace Visiosoft\PackagesModule\PackageEntry;

use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\PackageEntry\Contract\PackageEntryInterface;
use Anomaly\Streams\Platform\Model\Packages\PackagesPackageentryEntryModel;

class PackageEntryModel extends PackagesPackageentryEntryModel implements PackageEntryInterface
{
    public function saveArray($array, $packageId = null)
    {
        if ($packageId) {
            $packageEntryModel = new PackagesPackageentryEntryModel();
            foreach ($array as $categoryId => $item) {
                $packageEntryModel->newQuery()->updateOrCreate(
                    ['package_id' => $packageId, 'cat_id' => $categoryId],
                    [
                        'ad_limit' => $item['ad_limit'],
                        'time_limit' => $item['time'],
                        'commission' => $item['commission']
                    ]
                );
            }
        } else {
            $packageModel = new PackageModel();
            $lastPackageByUser = $packageModel->getLastCreatePackageByUser();
            foreach ($array as $key => $item) {
                $this->create([
                    'package_id' => $lastPackageByUser->id,
                    'cat_id' => $key,
                    'ad_limit' => $item['ad_limit'],
                    'time_limit' => $item['time'],
                    'commission' => $item['commission'],
                ]);
            }
        }
    }

    public function createEntry($array)
    {
        $this->create([
            'package_id' => $array['package_id'],
            'cat_id' => $array['cat_id'],
            'ad_limit' => $array['ad_limit'],
            'time_limit' => $array['time_limit'],
            'commission' => $array['commission'],
        ]);
    }

    public function deleteEntry($package_id)
    {
        $this->where('package_id', $package_id)->forceDelete();
    }

    public function getEntryPackage($id)
    {
        $categoryRepository = app(CategoryRepositoryInterface::class);
        $entry = $this->where('package_id', $id)->orderByDesc('id')->get();
        foreach ($entry as $index => $item) {
            if ($item->cat_id != "0") {
                $entry[$index]->category = $categoryRepository->find($item->cat_id);
            }
        }
        return $entry;
    }

}
