<?php namespace Visiosoft\PackagesModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PackagesModule\User\UserModel;

class PackageFEController extends PublicController
{
    public $category;
    public $model;
    public $user;
    public $adv;
    public $category_repository;
    private $packagesUserRepository;

    public function __construct(
        CategoryModel $category,
        PackageModel $model,
        UserModel $user,
        AdvModel $adv,
        CategoryRepositoryInterface $category_repository,
        UserRepositoryInterface $packagesUserRepository
    )
    {
        parent::__construct();
        $this->category = $category;
        $this->model = $model;
        $this->user = $user;
        $this->adv = $adv;
        $this->category_repository = $category_repository;
        $this->packagesUserRepository = $packagesUserRepository;
    }

    public function packageList()
    {
        $packages = $this->model->getPackages();
        return $this->view->make('visiosoft.module.packages::packages', compact('packages'));
    }

    public function packageAddCart($id)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }

        $package = $this->model->where('packages_packages.id', $id)->first();

        if ($this->packagesUserRepository->checkUserPackage($package->id)) {
            $this->messages->error(trans('visiosoft.module.packages::message.package_bought'));
            return redirect(route('visiosoft.module.packages::buy_package'));
        }

        $date = date('Y-m-d H:i:s');
        $expired = date('Y-m-d H:i:s',
            strtotime($date . ' + ' . $package->invoice_period . ' day'));

        $new_buy = array();
        $new_buy['user_id'] = Auth::id();
        $new_buy['package_id'] = $id;
        $new_buy['status'] = 'in_cart';
        $new_buy['expired_date'] = $expired;
        $save = $this->user->addPackageByCart($new_buy);
        $package->id = $save->id;
        $cart = $this->dispatch(new GetCart());
        $cart->add($package, 1);

        return redirect('cart');
    }

    public function AdLimitForNewAd($request)
    {
        $default_ad_limit = setting_value('visiosoft.module.packages::default_adv_limit');
        $count_user_ads = count($this->adv->userAdv()->get());
        if ($default_ad_limit < $count_user_ads) {
            $parent_cat = $this->category->getParentCats($request->cat1, 'parent_id');
            $package = $this->model->reduceLimit($parent_cat, 'reduce');
            if ($package != null) {
                $this->messages->error(trans('visiosoft.module.packages::message.buy_package_msg'));
                return true;
            }
        }
    }

    public function AdLimitForCategorySelection($id)
    {
        $cats = $this->category_repository->getSubCatById($id);
        if (empty($cats->toArray())) {
            $cats = trans('visiosoft.module.advs::message.create_ad_with_post_cat');
            $default_ad_limit = setting_value('visiosoft.module.packages::default_adv_limit');
            $durationLimit = setting_value('visiosoft.module.packages::limit_duration');
            $count_user_ads = $this->adv
                ->userAdv()
                ->whereDate('publish_at', '>', Carbon::now()->subDays((int)$durationLimit))
                ->count();
            if ($default_ad_limit <= $count_user_ads) {
                $parent_cat = $this->category->getParentCats($id, 'parent_id');
                $package = $this->model->reduceLimit($parent_cat);
                if ($package != null) {
                    $cats = $package;
                }
            }
        }
        return $cats;
    }

}
