<?php namespace Visiosoft\PackagesModule\PackageEntry;

use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\PackageEntry\Contract\PackageEntryInterface;
use Anomaly\Streams\Platform\Model\Packages\PackagesPackageentryEntryModel;

class PackageEntryModel extends PackagesPackageentryEntryModel implements PackageEntryInterface
{

    public function saveArray($array)
    {
        $packageModel = new PackageModel();
        $lastPackageByUser = $packageModel->getLastCreatePackageByUser();
        foreach ($array as $key => $item) {
            $this->create(
                [
                    'package_id' => $lastPackageByUser->id,
                    'cat_id' => $key,
                    'ad_limit' => $item['ad_limit'],
                    'time_limit' => $item['time'],
                ]
            );
        }
    }

    public function createEntry($array)
    {
        $this->create([
            'package_id' => $array['package_id'],
            'cat_id' => $array['cat_id'],
            'ad_limit' => $array['ad_limit'],
            'time_limit' => $array['time_limit'],
        ]);
    }

    public function deleteEntry($package_id)
    {
        $this->where('package_id', $package_id)->forceDelete();
    }

    public function getEntryPackage($id)
    {
        $categoryModel = new CategoryModel();
        $entry = $this->where('package_id', $id)->orderByDesc('id')->get();
        foreach ($entry as $index => $item) {
            if ($item->cat_id != "0") {
                $entry[$index]->category = $categoryModel->where('cats_category.id', $item->cat_id)->first();
            }
        }
        return $entry;
    }

}
