<?php namespace Visiosoft\PackagesModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Packages\PackagesAdvsLogsEntryModel;
use Anomaly\Streams\Platform\Model\Packages\PackagesCategoriesEntryModel;
use Visiosoft\CartsModule\Cart\Command\PackageCartRemoved;
use Visiosoft\PackagesModule\AdvsLog\AdvsLogModel;
use Visiosoft\PackagesModule\AdvsLog\AdvsLogRepository;
use Visiosoft\PackagesModule\AdvsLog\Contract\AdvsLogRepositoryInterface;
use Visiosoft\PackagesModule\Category\CategoryModel;
use Visiosoft\PackagesModule\Category\CategoryRepository;
use Visiosoft\PackagesModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\PackagesModule\Events\PackageApproved;
use Visiosoft\PackagesModule\Listeners\ApprovePendingAds;
use Visiosoft\PackagesModule\User\Listener\RemovePackageCart;
use Visiosoft\PackagesModule\Userentry\Contract\UserentryRepositoryInterface;
use Visiosoft\PackagesModule\Userentry\UserentryRepository;
use Anomaly\Streams\Platform\Model\Packages\PackagesUserentryEntryModel;
use Visiosoft\PackagesModule\Userentry\UserentryModel;
use Visiosoft\PackagesModule\PackageEntry\Contract\PackageEntryRepositoryInterface;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryRepository;
use Anomaly\Streams\Platform\Model\Packages\PackagesPackageEntryEntryModel;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryModel;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PackagesModule\User\UserRepository;
use Anomaly\Streams\Platform\Model\Packages\PackagesUsersEntryModel;
use Visiosoft\PackagesModule\User\UserModel;
use Visiosoft\PackagesModule\Package\Contract\PackageRepositoryInterface;
use Visiosoft\PackagesModule\Package\PackageRepository;
use Anomaly\Streams\Platform\Model\Packages\PackagesPackagesEntryModel;
use Visiosoft\PackagesModule\Package\PackageModel;

class PackagesModuleServiceProvider extends AddonServiceProvider
{

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        // Admin UserentryController
        'admin/packages/userentry' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UserentryController@index',
        'admin/packages/userentry/create' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UserentryController@create',
        'admin/packages/userentry/edit/{id}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UserentryController@edit',

        // Admin PackageEntryController
        'admin/packages/packageEntry' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackageEntryController@index',
        'admin/packages/packageEntry/create' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackageEntryController@create',
        'admin/packages/packageEntry/edit/{id}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackageEntryController@edit',

        // Admin PackagesController
        'admin/packages/getAdvPackage' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackagesController@getPackage',
        'admin/packages/create' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackagesController@create',
        'admin/packages/edit/{id}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackagesController@edit',
        'admin/packages' => [
            'as' => 'visiosoft.module.packages::packages',
            'uses' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackagesController@index',
        ],

        // Admin UsersController
        'admin/packages/users' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UsersController@index',
        'admin/packages/users/create' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UsersController@create',
        'admin/packages/users/edit/{id}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UsersController@edit',
        'admin/packages/approve/{id},{type}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UsersController@packageStatus',
        'admin/packages/users/{id}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UsersController@approve',

        // PackageFEController
        'profile/packages' => 'Visiosoft\PackagesModule\Http\Controller\PackageFEController@index',
        'profile/packages-list' => 'Visiosoft\PackagesModule\Http\Controller\PackageFEController@packageList',
        'class/packageControl/{id}' => 'Visiosoft\PackagesModule\Http\Controller\PackageFEController@advsStatus',
        'packages' => [
            'as' => 'visiosoft.module.packages::buy_package',
            'uses' => 'Visiosoft\PackagesModule\Http\Controller\PackageFEController@packageList'
        ],
        'my-packages' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.packages::my_packages',
            'uses' => 'Visiosoft\PackagesModule\Http\Controller\PackageFEController@myPackages'
        ],
        'packages/buy/{id}/{ad_id?}' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.packages::buy',
            'uses' => 'Visiosoft\PackagesModule\Http\Controller\PackageFEController@packageAddCart'
        ],
    ];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        PackageCartRemoved::class => [
            RemovePackageCart::class
        ],
        PackageApproved::class => [
            ApprovePendingAds::class
        ]
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        PackagesUserentryEntryModel::class => UserentryModel::class,
        PackagesPackageEntryEntryModel::class => PackageEntryModel::class,
        PackagesUsersEntryModel::class => UserModel::class,
        PackagesPackagesEntryModel::class => PackageModel::class,
        PackagesCategoriesEntryModel::class => CategoryModel::class,
        PackagesAdvsLogsEntryModel::class => AdvsLogModel::class
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        UserentryRepositoryInterface::class => UserentryRepository::class,
        PackageEntryRepositoryInterface::class => PackageEntryRepository::class,
        UserRepositoryInterface::class => UserRepository::class,
        PackageRepositoryInterface::class => PackageRepository::class,
        CategoryRepositoryInterface::class => CategoryRepository::class,
        AdvsLogRepositoryInterface::class => AdvsLogRepository::class
    ];

}
