<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;
use Visiosoft\CatsModule\Category\CategoryModel;

class VisiosoftModulePackagesCreatePackagesFields extends Migration
{

    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'plan_id' => 'anomaly.field_type.text',
        'price' => 'anomaly.field_type.integer',
        'currency' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'handler' => 'currencies',
            ],
        ],
        'category' => [
            'type' => 'visiosoft.field_type.dropbox',
            'config' => [
                'related' => CategoryModel::class
            ]
        ],
        'package' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\PackagesModule\Package\PackageModel::class
            ]
        ],
        'cat_id' => 'anomaly.field_type.integer',
        'ad_limit' => 'anomaly.field_type.integer',
        'time_limit' => 'anomaly.field_type.integer',
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ]
        ],
        'status' => [
            "type" => "anomaly.field_type.select",
            "config" => [
                "options" => ["approved" => "Approved", "pending" => "Pending"],
                "separator" => ":",
                "default_value" => 'pending',
                "mode" => "buttons",
            ]
        ],
        'expired_date' => 'anomaly.field_type.datetime',
        'remaining_ad_limit' => 'anomaly.field_type.integer',
        'remaining_time_limit' => 'anomaly.field_type.integer',
        'invoice_period' => 'anomaly.field_type.integer',
        "package_category" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\PackagesModule\Category\CategoryModel::class,
            ]
        ],
        "enabled" => [
            "type"   => "anomaly.field_type.boolean",
            "config" => [
                "default_value" => true,
            ]
        ],
        "features" => [
            "type"   => "anomaly.field_type.wysiwyg",
        ],
        "user_package" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\PackagesModule\User\UserModel::class,
            ]
        ],
    ];

}
