<?php namespace Visiosoft\PackagesModule\User;

use Carbon\Carbon;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class UserRepository extends EntryRepository implements UserRepositoryInterface
{
    protected $model;

    public function __construct(UserModel $model)
    {
        $this->model = $model;
    }

    public function checkUserPackage($packageId, $userId = null)
    {
        $userId = auth_id_if_null($userId);

        return $this->model->newQuery()
            ->where('user_id', $userId)
            ->where('package_id', $packageId)
            ->where('expired_date', '>', Carbon::now())
            ->first();
    }

    public function getSortedPackagesUsers($sortBy, $direction)
    {
        return $this->model->newQuery()->orderBy($sortBy, $direction)->get();
    }

    public function getUserPackages($userId = null)
    {
        $userId = auth_id_if_null($userId);

        return $this->model
            ->newQuery()
            ->where('user_id', $userId)
            ->where('status', 'approved')
            ->get();
    }
}
