<?php namespace Visiosoft\PackagesModule\PackageEntry;

use Visiosoft\PackagesModule\PackageEntry\Contract\PackageEntryRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class PackageEntryRepository extends EntryRepository implements PackageEntryRepositoryInterface
{
    protected $model;

    public function __construct(PackageEntryModel $model)
    {
        $this->model = $model;
    }

    public function getPackagesByCatID($catID)
    {
        return $this->newQuery()
            ->where('cat_id', $catID)
            ->where('ad_limit', '>', 0)
            ->groupBy('package_id')
            ->get();
    }
}
