<?php namespace Visiosoft\PackagesModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\User\UserModel;

class PackageFEController extends PublicController
{
    public function packageList(PackageModel $packageModel)
    {
        $packages = $packageModel->getPackages();
        return $this->view->make('visiosoft.module.packages::packages', compact('packages'));
    }

    public function packageAddCart(UserModel $userModel, PackageModel $packageModel, $id)
    {
        $package = $packageModel->where('packages_packages.id',$id)->first();
        $date = date('Y-m-d H:i:s');
        $expired = date('Y-m-d H:i:s',
            strtotime($date . ' + ' . $package->invoice_period . ' day'));

        $new_buy = array();
        $new_buy['user_id'] = Auth::id();
        $new_buy['package_id'] = $id;
        $new_buy['status'] = 'in_cart';
        $new_buy['expired_date'] = $expired;
        $save = $userModel->addPackageByCart($new_buy);
        $package->id = $save->id;
        $cart = $this->dispatch(new GetCart());
        $cart->add($package, 1);

        return redirect('cart');
    }

}
