<?php namespace Visiosoft\PackagesModule\User\Form;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\DB;

class UsersOptions
{
    public function handle(RelationshipFieldType $fieldType, UserRepositoryInterface $entries)
    {
        $fieldType->setOptions(
            $entries->newQuery()
                ->select(DB::raw("IF(first_name IS NULL or first_name = '', display_name, CONCAT(first_name, ' ', last_name)) AS name"), 'id')
                ->pluck('name', 'id')->all()
        );
    }
}
