<?php namespace Visiosoft\PackagesModule\Listeners;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\PackagesModule\AdvsLog\Contract\AdvsLogRepositoryInterface;
use Visiosoft\PackagesModule\Events\PackageApproved;

class ApprovePendingAds
{
    private $advsLogRepository;
    private $advRepository;

    public function __construct(AdvsLogRepositoryInterface $advsLogRepository, AdvRepositoryInterface $advRepository)
    {
        $this->advsLogRepository = $advsLogRepository;
        $this->advRepository = $advRepository;
    }

    public function handle(PackageApproved $event)
    {
        $pendingAds = $this->advsLogRepository
            ->getByUserPackageID($event->userPackage->id)
            ->pluck('adv_id')->all();

        $this->advRepository->approveAds($pendingAds);
    }
}