<?php namespace Visiosoft\PackagesModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\PackagesModule\AdvsLog\Contract\AdvsLogRepositoryInterface;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PackagesModule\User\UserModel;
use Visiosoft\PackagesModule\Userentry\Contract\UserentryRepositoryInterface;

class PackageFEController extends PublicController
{
    public $category;
    public $model;
    public $user;
    public $adv;
    public $category_repository;
    private $packagesUserRepository;
    private $categoryRepository;
    private $userentryRepository;
    private $advsLogRepository;

    public function __construct(
        CategoryModel $category,
        PackageModel $model,
        UserModel $user,
        AdvModel $adv,
        CategoryRepositoryInterface $category_repository,
        UserRepositoryInterface $packagesUserRepository,
        \Visiosoft\PackagesModule\Category\Contract\CategoryRepositoryInterface $categoryRepository,
        UserentryRepositoryInterface $userentryRepository,
        AdvsLogRepositoryInterface $advsLogRepository
    )
    {
        parent::__construct();
        $this->category = $category;
        $this->model = $model;
        $this->user = $user;
        $this->adv = $adv;
        $this->category_repository = $category_repository;
        $this->packagesUserRepository = $packagesUserRepository;
        $this->categoryRepository = $categoryRepository;
        $this->userentryRepository = $userentryRepository;
        $this->advsLogRepository = $advsLogRepository;
    }

    public function packageList()
    {
        $packagesCategories = $this->categoryRepository->all();
        $uncategorizedPackages = $this->model->getPackages(
            true,
            'uncategorized',
            request()->category_id
        );
        $packages = array();
        if (count($packagesCategories)) {
            foreach ($packagesCategories as $packagesCategory) {
                $categorizedPackages = $this->model->getPackages(
                    true,
                    $packagesCategory->id,
                    request()->category_id
                );
                if (count($categorizedPackages)) {
                    $packages[] = [
                        'category' => $packagesCategory,
                        'packages' => $categorizedPackages
                    ];
                }
            }
        }
        return $this->view->make('visiosoft.module.packages::packages', compact(
            'uncategorizedPackages',
            'packages'
        ));
    }

    public function myPackages()
    {
        $myPackages = $this->packagesUserRepository->getUserPackages();

        foreach ($myPackages as $index => $package) {
            $packageEntry = $this->userentryRepository
                ->newQuery()
                ->select([
                    'user_package_id',
                    DB::raw("SUM(ad_limit) as ad_limit"),
                    DB::raw("SUM(remaining_ad_limit) as remaining_ad_limit"),
                ])
                ->groupBy('user_package_id')
                ->where('user_package_id', $package->id)
                ->get();

            $now = Carbon::now();
            $maxDayLimit = $now->diffInDays($package->expired_date);
            $maxHourLimit = $now->diffInHours($package->expired_date);

            $myPackages[$index]->ad_limit = $packageEntry[0]->ad_limit;
            $myPackages[$index]->remaining_ad_limit = $packageEntry[0]->remaining_ad_limit;
            $myPackages[$index]->max_day_limit = $now->greaterThan($package->expired_date) ? 0 : $maxDayLimit;
            $myPackages[$index]->max_hour_limit = $now->greaterThan($package->expired_date) ? 0 : $maxHourLimit;
        }

        return $this->view->make('visiosoft.module.packages::my-packages', compact('myPackages'));
    }

    public function packageAddCart($id)
    {
        $package = $this->model->where('packages_packages.id', $id)->first();

        $date = date('Y-m-d H:i:s');
        $expired = date('Y-m-d H:i:s',
            strtotime($date . ' + ' . $package->invoice_period . ' day'));

        $new_buy = array();
        $new_buy['user_id'] = Auth::id();
        $new_buy['package_id'] = $id;
        $new_buy['status'] = 'in_cart';
        $new_buy['expired_date'] = $expired;
        $save = $this->user->addPackageByCart($new_buy);

        if ($adID = request()->ad_id) {
            $this->advsLogRepository->createAdLog([
                'adv' => $adID,
                'user_package' => $save->id
            ]);

            $this->messages->info(trans('visiosoft.module.packages::message.ad_package_creation'));
        }

        $package->id = $save->id;
        $cart = $this->dispatch(new GetCart());
        $cart->add($package, 1);

        return redirect('cart');
    }

    public function AdLimitForNewAd($request)
    {
        if (setting_value('visiosoft.module.packages::allow_pending_ad_creation')) {
            $this->messages->info(trans('visiosoft.module.packages::message.allow_pending_creation'));
            return ['allowPendingAds' => true];
        } else {
            $default_ad_limit = setting_value('visiosoft.module.packages::default_adv_limit');
            $count_user_ads = count($this->adv->userAdv(false, false)->get());
            if ($default_ad_limit <= $count_user_ads) {
                $parent_cat = $this->category->getParentCats($request->cat1, 'parent_id');
                $package = $this->model->reduceLimit($parent_cat, 'reduce');
                if ($package != null) {
                    $this->messages->error(trans('visiosoft.module.packages::message.buy_package_msg'));
                    return [
                        'redirect' => route('visiosoft.module.packages::buy_package')
                    ];
                }
            }
        }
    }

    public function AdLimitForCategorySelection($id)
    {
        $cats = $this->category_repository->getSubCatById($id);
        if (empty($cats->toArray())) {
            $cats = trans('visiosoft.module.advs::message.create_ad_with_post_cat');
            $default_ad_limit = setting_value('visiosoft.module.packages::default_adv_limit');
            $durationLimit = setting_value('visiosoft.module.packages::limit_duration');
            $count_user_ads = $this->adv
                ->userAdv(false, false)
                ->whereDate('publish_at', '>', Carbon::now()->subDays((int)$durationLimit))
                ->count();
            if ($default_ad_limit <= $count_user_ads && !setting_value('visiosoft.module.packages::allow_pending_ad_creation')) {
                $parent_cat = $this->category->getParentCats($id, 'parent_id', false);
                $package = $this->model->reduceLimit($parent_cat);
                if ($package != null) {
                    $cats = $package;
                }
            }
        }
        return $cats;
    }

}
