<?php namespace Visiosoft\PackagesModule\Package;

use Illuminate\Support\Facades\Auth;
use Visiosoft\PackagesModule\Events\PackageApproved;
use Visiosoft\PackagesModule\Package\Contract\PackageInterface;
use Anomaly\Streams\Platform\Model\Packages\PackagesPackagesEntryModel;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryModel;
use Visiosoft\PackagesModule\User\UserModel;
use Visiosoft\PackagesModule\Userentry\UserentryModel;

class PackageModel extends PackagesPackagesEntryModel implements PackageInterface
{
    public function getLastCreatePackageByUser()
    {
        return $this->where('created_by_id', Auth::id())->orderByDesc('id')->first();
    }

    public function getPackageByLoggedInUser()
    {
        $PackageUserModel = new UserModel();
        $PackageUserEntryModel = new UserentryModel();
        $packages = $PackageUserModel
            ->where('user_id', Auth::id())
            ->whereDate('expired_date', '>', date("Y-m-d H:i:s"))
            ->where('status', 'approved')->get();
        $PackageList = array();
        foreach ($packages as $package) {
            $addPackage = array();
            $addPackage['expired'] = $package->expired_date;
            $addPackage['package'] = $this->find($package->package_id);
            $addPackage['entry'] = $PackageUserEntryModel->getEntryPackageByProfile($package->package_id);
            $PackageList[] = $addPackage;
        }
        return $PackageList;
    }

    public function getPackages($enabled = false, $packageCategoryId = null)
    {
        $PackageEntryModel = new PackageEntryModel();
        $packages = $enabled ? $this->where('enabled', true) : $this;
        if ($packageCategoryId) {
            $packages = $packageCategoryId === 'uncategorized' ?
                $packages->whereNull('package_category_id')->get() :
                $packages->where('package_category_id', $packageCategoryId)->get();
        } else {
            $packages = $packages->get();
        }
        $PackageList = array();
        foreach ($packages as $package) {
            $addPackage = array();
            $addPackage['package'] = $package;
            $addPackage['entry'] = $PackageEntryModel->getEntryPackage($package->id);
            $PackageList[] = $addPackage;
        }
        return $PackageList;
    }

    public function PendingStatus($id)
    {
        $PackageUserModel = new UserModel();
        $PackageUserModel->setStatus($id, 'pending');
    }

    public function ApprovedStatus($id)
    {
        $PackageUserModel = new UserModel();
        $userEntryModel = new UserentryModel();
        $packageEntryModel = new PackageEntryModel();
        $package = $PackageUserModel->getDetail($id);
        $PackageEntry = $packageEntryModel->getEntryPackage($package->package_id);
        $userEntryModel->addEntryUserArray($PackageEntry, $id);
        $PackageUserModel->setStatus($id, 'approved');

        event(new PackageApproved($package));
    }

    public function getPackage($id)
    {
        return $this->where('packages_packages.id', $id)->first();
    }

    public function queryNewAds($category_id)
    {
        $PackageUserEntryModel = new UserentryModel();
        $PackageUserModel = new UserModel();
        $packages = $PackageUserModel
            ->where('user_id', Auth::id())
            ->whereDate('expired_date', '>', date("Y-m-d H:i:s"))
            ->where('status', 'approved')->get();
        $active_entry_by_categories = array();
        $entry_id_list = array();
        foreach ($packages as $package) {
            $active_package = $PackageUserEntryModel->getEntryPackage($package->id, $package->package_id, $category_id, $entry_id_list);
            foreach ($active_package as $item) {
                $entry_id_list[] = $item->id;
            }
            if ($active_package) {
                $active_entry_by_categories = array_merge($active_entry_by_categories, $active_package->toArray());
            }
        }
        return $active_entry_by_categories;
    }

    public function reduceLimit($category_id, $type = null)
    {
        $PackageUserEntryModel = new UserentryModel();
        $user_get_limits = $this->queryNewAds($category_id);
        if (count($user_get_limits) > 0) {
            if ($type != null) {
                $PackageUserEntryModel->reduce($user_get_limits[0]['id']);
            }
            return null;
        } else {
            $package = trans('visiosoft.module.packages::message.max_ads_limit');
            $package['link'] = '/packages';
            return $package;
        }
    }

    public function reduceTimeLimit($category_id)
    {
        $PackageUserEntryModel = new UserentryModel();
        $user_get_limits = $this->getAdTimeUser($category_id);
        if (count($user_get_limits) > 0) {
            $PackageUserEntryModel->reduceTime($user_get_limits[0]['id']);
            return $user_get_limits[0]['time_limit'];
        } else {
            return null;
        }
    }

    public function getAdTimeUser($category_id)
    {
        $PackageUserEntryModel = new UserentryModel();
        $PackageUserModel = new UserModel();
        $packages = $PackageUserModel
            ->where('user_id', Auth::id())
            ->whereDate('expired_date', '>', date("Y-m-d H:i:s"))
            ->where('status', 'approved')->get();
        $active_entry_by_categories = array();
        foreach ($packages as $package) {
            $active_package = $PackageUserEntryModel->getEntryPackageByTime($package->id, $category_id);
            if ($active_package) {
                $active_entry_by_categories = array_merge($active_entry_by_categories, $active_package->toArray());
            }
        }
        return $active_entry_by_categories;
    }
}
