<?php namespace Visiosoft\PackagesModule\Userentry;

use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\PackagesModule\Userentry\Contract\UserentryInterface;
use Anomaly\Streams\Platform\Model\Packages\PackagesUserentryEntryModel;

class UserentryModel extends PackagesUserentryEntryModel implements UserentryInterface
{
    public function addEntryUser($object, $relation_id)
    {
        $this->create([
            'package_id' => $object->package_id,
            'cat_id' => $object->cat_id,
            'ad_limit' => $object->ad_limit,
            'user_package_id' => $relation_id,
            'time_limit' => $object->time_limit,
            'remaining_ad_limit' => $object->ad_limit,
            'remaining_time_limit' => $object->ad_limit,
        ]);
    }

    public function addEntryUserArray($array, $user_relation_id)
    {
        foreach ($array as $object) {
            $this->addEntryUser($object, $user_relation_id);
        }
    }

    public function getEntryPackage($user_id, $id, $cat_id, $entry_list)
    {
        $categoryModel = new CategoryModel();
        $entry = $this::query()
            ->whereIn('cat_id', [0, $cat_id])
            ->whereNotIn('id', $entry_list)
            ->where('package_id', $id)
            ->where('user_package_id', $user_id)
            ->where('remaining_ad_limit', '>', 0)
            ->orderByDesc('id')->get();
        foreach ($entry as $index => $item) {
            if ($item->cat_id != "0") {
                $entry[$index]->category = $categoryModel->where('cats_category.id', $item->cat_id)->first();
            }
        }
        return $entry;
    }

    public function getEntryPackageByTime($id, $cat_id)
    {
        $entry = $this
            ->whereIn('cat_id', [0, $cat_id])
            ->where('package_id', $id)
            ->where('remaining_time_limit', '>', 0)
            ->orderByDesc('id')->get();

        return $entry;
    }

    public function getEntryPackageByProfile($id)
    {
        $categoryModel = new CategoryModel();
        $entry = $this->where('package_id', $id)->orderByDesc('id')->get();
        foreach ($entry as $index => $item) {
            if ($item->cat_id != "0") {
                $entry[$index]->category = $categoryModel->where('cats_category.id', $item->cat_id)->first();
            }
        }
        return $entry;
    }

    public function reduce($id)
    {
        $entry = $this::query()->where('id', $id)->first();
        if ($entry) {
            $entry->update([
                'remaining_ad_limit' => $entry->remaining_ad_limit - 1,
            ]);
        }
    }

    public function reduceTime($id)
    {
        $entry = $this::query()->where('id', $id)->first();
        if ($entry) {
            $entry->update([
                'remaining_time_limit' => $entry->remaining_time_limit - 1,
            ]);
        }
    }

}
