<?php namespace Visiosoft\PackagesModule\Http\Controller\Admin;

use Visiosoft\PackagesModule\PackageEntry\Form\PackageEntryFormBuilder;
use Visiosoft\PackagesModule\PackageEntry\Table\PackageEntryTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class PackageEntryController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param PackageEntryTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(PackageEntryTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param PackageEntryFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(PackageEntryFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param PackageEntryFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(PackageEntryFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
