<?php namespace Visiosoft\PackagesModule\User;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\PackagesModule\PackageEntry\Contract\PackageEntryRepositoryInterface;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;

class UserCriteria extends EntryCriteria
{

    private $userRepository;
    private $packageEntryRepository;

    public function __construct(
        Builder $query, StreamInterface $stream, $method,
        UserRepositoryInterface $userRepository,
        PackageEntryRepositoryInterface $packageEntryRepository
    )
    {
        parent::__construct($query, $stream, $method);
        $this->userRepository = $userRepository;
        $this->packageEntryRepository = $packageEntryRepository;
    }

    public function getUserCategoryCommission($category, $userId = null) {
        $userId = $userId ?: auth()->id();

        $userPackagesIDs = $this->userRepository
            ->newQuery()
            ->where('status', 'approved')
            ->where('user_id', $userId)
            ->whereDate('expired_date', '>', Carbon::now())
            ->pluck('package_id');

        $commission = $this->packageEntryRepository
            ->newQuery()
            ->whereIn('package_id', $userPackagesIDs)
            ->whereIn('cat_id', [0, $category])
            ->min('commission');

        return is_null($commission) ? setting_value('visiosoft.module.orders::commission') : $commission;
    }
}
