<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePackagesCreateAdvsLogsStream extends Migration
{
    protected $delete = true;

    protected $stream = [
        'slug' => 'advs_logs',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'adv' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\AdvsModule\Adv\AdvModel::class
            ]
        ],
    ];

    protected $assignments = [
        'adv' => [
            'required' => true,
        ],
        'user_package' => [
            'required' => true,
        ],
    ];
}
