<?php namespace Visiosoft\PackagesModule\Package;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Visiosoft\PackagesModule\Package\Contract\PackageRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PackagesModule\Userentry\Contract\UserentryRepositoryInterface;

use Visiosoft\PackagesModule\User\UserModel;

class PackageRepository extends EntryRepository implements PackageRepositoryInterface
{
    protected $model;
    protected $packagesUserRepository;
    protected $userentryRepository;

    public function __construct(PackageModel $model, UserRepositoryInterface $packagesUserRepository, UserentryRepositoryInterface $userentryRepository)
    {
        $this->model = $model;
        $this->packagesUserRepository = $packagesUserRepository;
        $this->userentryRepository = $userentryRepository;
    }

    public function getPackage()
    {
        return UserModel::query()
            ->leftJoin('packages_packages as pk', 'packages_users.packageAdvs_id', '=', 'pk.id')
            ->where('user_id', Auth::id())
            ->select('packages_users.*', 'pk.name as name', 'pk.time as time')
            ->get();
    }

    public function getMyPackages(){
        $myPackages = $this->packagesUserRepository->getUserPackages();
        foreach ($myPackages as $index => $package) {
            $packageEntry = $this->userentryRepository
                ->newQuery()
                ->select([
                    'user_package_id',
                    DB::raw("SUM(ad_limit) as ad_limit"),
                    DB::raw("SUM(remaining_ad_limit) as remaining_ad_limit"),
                ])
                ->groupBy('user_package_id')
                ->where('user_package_id', $package->id)
                ->get();

            $now = Carbon::now();
            $maxDayLimit = $now->diffInDays($package->expired_date);
            $maxHourLimit = $now->diffInHours($package->expired_date);

            $myPackages[$index]->ad_limit = $packageEntry[0]->ad_limit;
            $myPackages[$index]->remaining_ad_limit = $packageEntry[0]->remaining_ad_limit;
            $myPackages[$index]->max_day_limit = $now->greaterThan($package->expired_date) ? 0 : $maxDayLimit;
            $myPackages[$index]->max_hour_limit = $now->greaterThan($package->expired_date) ? 0 : $maxHourLimit;
        }
        return $myPackages;
    }
}
