<?php namespace Visiosoft\PackagesModule\Listeners;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\PackagesModule\AdvsLog\Contract\AdvsLogRepositoryInterface;
use Visiosoft\PackagesModule\Events\PackageApproved;
use Visiosoft\PackagesModule\Package\PackageModel;

class ApprovePendingAds
{
    private $advsLogRepository;
    private $advRepository;
    private $packageModel;

    public function __construct(
        AdvsLogRepositoryInterface $advsLogRepository,
        AdvRepositoryInterface $advRepository,
        PackageModel $packageModel
    )
    {
        $this->advsLogRepository = $advsLogRepository;
        $this->advRepository = $advRepository;
        $this->packageModel = $packageModel;
    }

    public function handle(PackageApproved $event)
    {
        $pendingAds = $this->advsLogRepository
            ->getByUserPackageID($event->userPackage->id)
            ->pluck('adv_id')
            ->all();

        $this->advRepository->approveAds($pendingAds);

        foreach ($pendingAds as $pendingAd) {
            $ad = $this->advRepository->find($pendingAd);
            $this->packageModel->reduceLimit($ad->cat1, 'reduce');
        }
    }
}