<?php namespace Visiosoft\PackagesModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\PackagesModule\Package\Form\PackageFormBuilder;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\Package\Table\PackageTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\PackagesModule\PackageEntry\Contract\PackageEntryRepositoryInterface;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryModel;

class PackagesController extends AdminController
{

    private $packageEntryModel;
    private $packageModel;
    private $packageEntryRepository;

    public function __construct(
        PackageEntryModel $packageEntryModel,
        PackageModel $packageModel,
        PackageEntryRepositoryInterface $packageEntryRepository,
        MessageBag $messages
    )
    {
        parent::__construct();
        $this->packageEntryModel = $packageEntryModel;
        $this->packageModel = $packageModel;
        $this->packageEntryRepository = $packageEntryRepository;
        $this->messages = $messages;
    }

    public function index(PackageTableBuilder $table)
    {
        if (request()->action == "delete") {
            foreach (request()->id as $item)
            {
                $this->packageEntryModel->deleteEntry($item);
            }
        }
        $table->setColumns(['name', 'invoice_period', 'price' => [
            'value' => 'entry.price ~" "~ entry.currency',
        ]]);
        return $table->render();
    }

    public function create(PackageFormBuilder $form)
    {
        if (request()->type) {
            $field = [
                'ad_limit' => [
                    'label' => trans('visiosoft.module.packages::field.create_ad_limit.name'),
                    'required' => true,
                    'value' => setting_value('visiosoft.module.packages::default_adv_limit'),
                    'min' => setting_value('visiosoft.module.packages::default_adv_limit'),
                    'type' => 'anomaly.field_type.integer',
                ],
                'time' => [
                    'label' => trans('visiosoft.module.packages::field.ad_publish_time.name'),
                    'required' => true,
                    'value' => setting_value('visiosoft.module.advs::default_published_time'),
                    'min' => setting_value('visiosoft.module.advs::default_published_time'),
                    'type' => 'anomaly.field_type.integer',
                ],
            ];
            $form->setFields(array_merge(
                ['name', 'plan_id', 'price', 'currency','invoice_period', 'package_category', 'enabled'],
                $field
            ));
            if (request()->action == "save") {
                $form->skipField('ad_limit');
                $form->skipField('time');
                $form->render();
                $errors = $form->getFormErrors()->getMessages();
                if (count($errors)) {
                    foreach ($errors as $messages) {
                        foreach ($messages as $message) {
                            $this->messages->error($message);
                        }
                    }
                    return redirect()->back();
                }
                $lastPackageByUser = $this->packageModel->getLastCreatePackageByUser();

                $this->packageEntryModel->createEntry([
                    'package_id' => $lastPackageByUser->id,
                    'cat_id' => 0,
                    'ad_limit' => request()->ad_limit,
                    'time_limit' => request()->time,
                ]);
                return redirect('admin/packages')->withSuccess([trans('visiosoft.module.packages::message.package_success_create')]);
            }
        } else {
            if (request()->action == "save") {
                $form->render();
                $entry = array();
                foreach (request()->all() as $index => $item) {
                    if (substr($index, 0, 4) == "time" or substr($index, 0, 7) == "adlimit") {
                        if (substr($index, 0, 4) == "time") {
                            $entry[substr($index, 4)]['time'] = $item;
                        } else {
                            $entry[substr($index, 7)]['ad_limit'] = $item;
                        }
                    }
                }
                $this->packageEntryModel->saveArray($entry);
                return redirect('admin/packages')->withSuccess([trans('visiosoft.module.packages::message.package_success_create')]);
            }
        }
        return $form->render();
    }

    public function edit(PackageFormBuilder $form, $id)
    {
        $packageEntry = $this->packageEntryRepository->findAllBy('package_id', $id);
        if (count($packageEntry) === 1 && $packageEntry[0]->cat_id === 0) {
            $field = [
                'ad_limit' => [
                    'label' => trans('visiosoft.module.packages::field.create_ad_limit.name'),
                    'required' => true,
                    'value' => $packageEntry[0]->ad_limit,
                    'min' => setting_value('visiosoft.module.packages::default_adv_limit'),
                    'type' => 'anomaly.field_type.integer',
                ],
                'time' => [
                    'label' => trans('visiosoft.module.packages::field.ad_publish_time.name'),
                    'required' => true,
                    'value' => $packageEntry[0]->time_limit,
                    'min' => setting_value('visiosoft.module.advs::default_published_time'),
                    'type' => 'anomaly.field_type.integer',
                ],
            ];
            $form->setFields(array_merge(
                ['name', 'plan_id', 'price', 'currency','invoice_period', 'package_category', 'enabled'],
                $field
            ));
            if (request()->action == "save") {
                $form->skipField('ad_limit');
                $form->skipField('time');
                $form->render($id);

                $this->packageEntryModel->newQuery()->updateOrCreate(
                    ['package_id' => $id, 'cat_id' => 0],
                    ['ad_limit' => request()->ad_limit, 'time_limit' => request()->time]
                );
                return redirect('admin/packages/edit/' . $id)->withSuccess([trans('visiosoft.module.packages::message.package_success_update')]);
            }
        } else {
            if (request()->action == "save") {
                $form->render($id);
                $entry = array();
                foreach (request()->all() as $index => $item) {
                    if (substr($index, 0, 4) == "time" or substr($index, 0, 7) == "adlimit") {
                        if (substr($index, 0, 4) == "time") {
                            $entry[substr($index, 4)]['time'] = $item;
                        } else {
                            $entry[substr($index, 7)]['ad_limit'] = $item;
                        }
                    }
                }
                $this->packageEntryModel->saveArray($entry, $id);
                return redirect('admin/packages/edit/' . $id)->withSuccess([trans('visiosoft.module.packages::message.package_success_update')]);
            }
        }
        return $form->render($id);
    }
}
