<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePackagesAddCategoryAndStatusFields extends Migration
{

    /**
     * Don't delete stream on rollback
     * because this isn't creating the
     * stream only referencing it.
     */
    protected $delete = false;

    /**
     * Any additional information will
     * be updated. Slug helps find
     * the stream to work with for
     * assignments that follow.
     */
    protected $stream = [
        'slug' => 'packages',
    ];

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        "package_category" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\PackagesModule\Category\CategoryModel::class,
            ]
        ],
        "enabled" => [
            "type"   => "anomaly.field_type.boolean",
            "config" => [
                "default_value" => true,
            ]
        ]
    ];

    /**
     * The field's assignment.
     *
     * @var array
     */
    protected $assignments = [
        "package_category",
        "enabled"
    ];

}
