<?php namespace Visiosoft\PackagesModule\User\Listener;

use Visiosoft\CartsModule\Cart\Event\CartRemove;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;

class RemovePackageCart
{
    private $userRepository;

    public function __construct(UserRepositoryInterface $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    public function handle(CartRemove $event)
    {
        $item = $event->getItem();
        if ($item->entry_type == "Visiosoft\PackagesModule\Package\PackageModel") {
            $this->userRepository->newQuery()->where('id', $event->saleItem->entry_id)->delete();
        }
    }
}
