<?php namespace Visiosoft\PackagesModule\User;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;
use Visiosoft\PackagesModule\Userentry\Contract\UserentryRepositoryInterface;

class UserObserver extends EntryObserver
{
    private $userentryRepository;

    public function __construct(UserentryRepositoryInterface $userentryRepository)
    {
        parent::__construct();
        $this->userentryRepository = $userentryRepository;
    }

    public function deleting(EntryInterface $entry)
    {
        $this->userentryRepository->newQuery()->where('user_package_id', $entry->id)->delete();

        parent::deleting($entry);
    }
}
