<?php namespace Visiosoft\PackagesModule\AdvsLog;

use Visiosoft\PackagesModule\AdvsLog\Contract\AdvsLogRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class AdvsLogRepository extends EntryRepository implements AdvsLogRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var AdvsLogModel
     */
    protected $model;

    /**
     * Create a new AdvsLogRepository instance.
     *
     * @param AdvsLogModel $model
     */
    public function __construct(AdvsLogModel $model)
    {
        $this->model = $model;
    }

    public function getByUserPackageID($userPackageID)
    {
        return $this->findAllBy('user_package_id', $userPackageID);
    }

    public function createAdLog($params)
    {
        return $this->create($params);
    }

    public function getByUserEntryIds(array $user_entry_ids)
    {
        return $this->newQuery()->whereIn('user_entry_id', $user_entry_ids)->get();
    }
}
