<?php namespace Visiosoft\PackagesModule\User;

use Carbon\Carbon;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class UserRepository extends EntryRepository implements UserRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var UserModel
     */
    protected $model;

    /**
     * Create a new UserRepository instance.
     *
     * @param UserModel $model
     */
    public function __construct(UserModel $model)
    {
        $this->model = $model;
    }

    public function checkUserPackage($packageId, $userId = null) {
        if (!$userId) {
            $userId = auth()->id();
        }

        return $this->newQuery()
            ->where('user_id', $userId)
            ->where('package_id', $packageId)
            ->where('expired_date', '>', Carbon::now())
            ->first();
    }
}
