<?php namespace Visiosoft\PackagesModule\User\Listener;

use Visiosoft\CartsModule\Cart\Command\PackageCartRemoved;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;

class RemovePackageCart
{
    /**
     * @var UserRepositoryInterface
     */
    private $userRepository;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(UserRepositoryInterface $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    public function handle(PackageCartRemoved $event)
    {
        $this->userRepository->newQuery()->where('id', $event->saleItem->entry_id)->delete();
    }
}
