<?php namespace Visiosoft\PackagesModule\Package;

use Illuminate\Support\Facades\Auth;
use Visiosoft\PackagesModule\Package\Contract\PackageRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\PackagesModule\User\UserModel;

class PackageRepository extends EntryRepository implements PackageRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var PackageModel
     */
    protected $model;

    /**
     * Create a new PackageRepository instance.
     *
     * @param PackageModel $model
     */
    public function __construct(PackageModel $model)
    {
        $this->model = $model;
    }

    public function getPackage()
    {
        return UserModel::query()
            ->leftJoin('packages_packages as pk', 'packages_users.packageAdvs_id', '=', 'pk.id')
            ->where('user_id',Auth::id())
            ->select('packages_users.*','pk.name as name','pk.time as time')
            ->get();
    }
}
