<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePackagesMakeFeaturesTranslatable extends Migration
{

    public function up()
    {
        $stream = $this->streams()->findBySlugAndNamespace('packages', 'packages');
        $field = $this->fields()->findBySlugAndNamespace('features', 'packages');
        $assignment = $this->assignments()->findByStreamAndField($stream, $field);

        $assignment
            ->setAttribute('translatable', true)
            ->save();
    }

    public function down()
    {
        $stream = $this->streams()->findBySlugAndNamespace('packages', 'packages');
        $field = $this->fields()->findBySlugAndNamespace('packages', 'features');
        $assignment = $this->assignments()->findByStreamAndField($stream, $field);

        $assignment
            ->setAttribute('translatable', false)
            ->save();
    }
}
