<?php namespace Visiosoft\PackagesModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Packages\PackagesCategoriesEntryModel;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Visiosoft\PackagesModule\Category\CategoryModel;
use Visiosoft\PackagesModule\Category\CategoryRepository;
use Visiosoft\PackagesModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\PackagesModule\User\Listener\CreateUser;
use Visiosoft\PackagesModule\Userentry\Contract\UserentryRepositoryInterface;
use Visiosoft\PackagesModule\Userentry\UserentryRepository;
use Anomaly\Streams\Platform\Model\Packages\PackagesUserentryEntryModel;
use Visiosoft\PackagesModule\Userentry\UserentryModel;
use Visiosoft\PackagesModule\PackageEntry\Contract\PackageEntryRepositoryInterface;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryRepository;
use Anomaly\Streams\Platform\Model\Packages\PackagesPackageEntryEntryModel;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryModel;
use Visiosoft\PackagesModule\Timepackage\Contract\TimepackageRepositoryInterface;
use Visiosoft\PackagesModule\Timepackage\TimepackageRepository;
use Anomaly\Streams\Platform\Model\Packages\PackagesTimepackageEntryModel;
use Visiosoft\PackagesModule\Timepackage\TimepackageModel;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PackagesModule\User\UserRepository;
use Anomaly\Streams\Platform\Model\Packages\PackagesUsersEntryModel;
use Visiosoft\PackagesModule\User\UserModel;
use Visiosoft\PackagesModule\Package\Contract\PackageRepositoryInterface;
use Visiosoft\PackagesModule\Package\PackageRepository;
use Anomaly\Streams\Platform\Model\Packages\PackagesPackagesEntryModel;
use Visiosoft\PackagesModule\Package\PackageModel;
use Illuminate\Routing\Router;

class PackagesModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/packages/userentry' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UserentryController@index',
        'admin/packages/userentry/create' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UserentryController@create',
        'admin/packages/userentry/edit/{id}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UserentryController@edit',
        'admin/packages/packageEntry' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackageEntryController@index',
        'admin/packages/packageEntry/create' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackageEntryController@create',
        'admin/packages/packageEntry/edit/{id}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackageEntryController@edit',
        'admin/packages/getAdvPackage' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackagesController@getPackage',
        'admin/packages/getTimePackage' => 'Visiosoft\PackagesModule\Http\Controller\Admin\TimepackageController@getPackage',
        'admin/packages/users' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UsersController@index',
        'admin/packages/users/create' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UsersController@create',
        'admin/packages/users/edit/{id}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UsersController@edit',
        'admin/packages/approve/{id},{type}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UsersController@packageStatus',
        'admin/packages' => [
            'as' => 'visiosoft.module.packages::packages',
            'uses' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackagesController@index',
        ],
        'admin/packages/create' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackagesController@create',
        'admin/packages/edit/{id}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\PackagesController@edit',
        'profile/packages' => 'Visiosoft\PackagesModule\Http\Controller\PackageFEController@index',
        'profile/packages-list' => 'Visiosoft\PackagesModule\Http\Controller\PackageFEController@packageList',
        'class/packageControl/{id}' => 'Visiosoft\PackagesModule\Http\Controller\PackageFEController@advsStatus',
        'packages' => [
            'as' => 'visiosoft.module.packages::buy_package',
            'uses' => 'Visiosoft\PackagesModule\Http\Controller\PackageFEController@packageList'
        ],
        'packages/buy/{id}' => [
            'as' => 'visiosoft.module.packages::buy',
            'uses' => 'Visiosoft\PackagesModule\Http\Controller\PackageFEController@packageAddCart'
        ],
        'admin/packages/users/{id}' => 'Visiosoft\PackagesModule\Http\Controller\Admin\UsersController@approve',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\PackagesModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\PackagesModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        UserHasRegistered::class => [
            CreateUser::class,
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\PackagesModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        PackagesUserentryEntryModel::class => UserentryModel::class,
        PackagesPackageEntryEntryModel::class => PackageEntryModel::class,
        PackagesTimepackageEntryModel::class => TimepackageModel::class,
        PackagesUsersEntryModel::class => UserModel::class,
        PackagesPackagesEntryModel::class => PackageModel::class,
        PackagesCategoriesEntryModel::class => CategoryModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        UserentryRepositoryInterface::class => UserentryRepository::class,
        PackageEntryRepositoryInterface::class => PackageEntryRepository::class,
        TimepackageRepositoryInterface::class => TimepackageRepository::class,
        UserRepositoryInterface::class => UserRepository::class,
        PackageRepositoryInterface::class => PackageRepository::class,
        CategoryRepositoryInterface::class => CategoryRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::form/form' => 'visiosoft.module.packages::form/form'
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
