<?php namespace Visiosoft\PackagesModule\User;

use Carbon\Carbon;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class UserRepository extends EntryRepository implements UserRepositoryInterface
{

    public function checkUserPackage($packageId, $userId = null) {
        if (!$userId) {
            $userId = auth()->id();
        }

        return $this->newQuery()
            ->where('user_id', $userId)
            ->where('package_id', $packageId)
            ->where('expired_date', '>', Carbon::now())
            ->first();
    }

    public function getSortedPackagesUsers($sortBy, $direction) {
        return $this->newQuery()->orderBy($sortBy, $direction)->get();
    }

    public function getUserPackages($userId = null) {
        $userId = $userId ?: auth()->id();

        return $this
            ->newQuery()
            ->where('user_id', $userId)
            ->where('status', 'approved')
            ->get();
    }
}
