<?php namespace Visiosoft\PackagesModule\User;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryModel;
use Visiosoft\PackagesModule\User\Contract\UserInterface;
use Anomaly\Streams\Platform\Model\Packages\PackagesUsersEntryModel;
use Visiosoft\PackagesModule\Userentry\UserentryModel;

class UserModel extends PackagesUsersEntryModel implements UserInterface
{

    public function addPackageByCart($array)
    {
        return $this->create([
            'user_id' => $array['user_id'],
            'package_id' => $array['package_id'],
            'status' => $array['status'],
            'expired_date' => $array['expired_date'],
        ]);
    }

    public function setStatus($id, $status)
    {
        $this->find($id)->update([
            'status' => $status,
        ]);
    }

    public function getDetail($id)
    {
        return $this->find($id);
    }


    public function getUser()
    {
        return UserModel::query();
    }

    public function getUserPackages()
    {
        return $this->getUser()
            ->where('packages_users.user_id', Auth::id())
            ->leftJoin('packages_packages as pk', 'packages_users.package_id', '=', 'pk.id')
            ->leftJoin('packages_packageentry as pt', 'pk.id', '=', 'pt.package_id');
    }

    public function getTimePackagesDetail($id)
    {
        return $this->getUser()->find($id)
            ->orderByDesc('id')
            ->leftJoin('packages_timepackage as pk', 'packages_users.package_id', '=', 'pk.id')
            ->select('pk.name as name', 'pk.price as price', 'packages_users.id as id')
            ->first();
    }

    public function getAdvPackagesDetail($id)
    {
        return $this->getUser()->find($id)
            ->orderByDesc('id')
            ->leftJoin('packages_packages as pk', 'packages_users.package_id', '=', 'pk.id')
            ->select('pk.name as name', 'pk.price as price', 'packages_users.id as id')
            ->first();
    }

    public function getUserPackagesAdvs()
    {
        return $this->getUserPackages()->where('packages_users.package_type', 'advs')->orderByDesc('packages_users.id');
    }

    public function findUser()
    {
        return UserModel::find(Auth::id());
    }

    public function status($id, $type)
    {
        $package = UserModel::find($id);
        $package->update(['status' => $type]);
        return $package;
    }

    public function userPackage()
    {

        return $this->getUser()
            ->where('packages_users.created_by_id', Auth::id());
    }

    public function isUser($id)
    {
        return $this->userPackage()->where('packages_users.id', $id)->first();
    }

    public function createUserPackage($user, $package_id, $expired_day)
    {
        $packageEntryModel = new PackageEntryModel();
        $packageUserEntryModel = new UserentryModel();
        $date = date('Y-m-d H:i:s');
        $this->create([
            'user_id' => $user->id,
            'package_id' => $package_id,
            'status' => 'approved',
            'expired_date' => date('Y-m-d H:i:s',
                strtotime($date . ' + ' . $expired_day . ' day'))
        ]);

        $Packageentry = $packageEntryModel->getEntryPackage($package_id);
        $packageUserEntryModel->addEntryUserArray($Packageentry);
    }

    public function getUserCategoryCommission($category, $userId = null) {
        $userId = $userId ?: auth()->id();

        $userPackagesIDs = $this
            ->newQuery()
            ->where('status', 'approved')
            ->where('user_id', $userId)
            ->whereDate('expired_date', '>', Carbon::now())
            ->pluck('package_id');

        $packageEntryModel = new PackageEntryModel();
        $commission = $packageEntryModel
            ->newQuery()
            ->whereIn('package_id', $userPackagesIDs)
            ->whereIn('cat_id', [0, $category])
            ->min('commission');

        return is_null($commission) ? setting_value('visiosoft.module.orders::commission') : $commission;
    }
}
