<?php namespace Visiosoft\PackagesModule\Http\Controller\Admin;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Illuminate\Http\Request;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\PackagesModule\Package\Form\PackageFormBuilder;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\Package\Table\PackageTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Illuminate\Support\Facades\DB;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryModel;

class PackagesController extends AdminController
{

    public function index(PackageTableBuilder $table, Request $request, PackageEntryModel $packageEntryModel)
    {
        if ($request->action == "delete") {
            foreach ($request->id as $item)
            {
                $packageEntryModel->deleteEntry($item);
            }
        }
        $table->setColumns(['name', 'time', 'price' => [
            'value' => 'entry.price ~" "~ entry.currency',
        ]]);
        return $table->render();
    }

    public function create(PackageFormBuilder $form, Request $request, PackageEntryModel $packageEntryModel, SettingRepositoryInterface $settingRepository, CategoryModel $categoryModel, PackageModel $packageModel)
    {
        if ($request->type) {
            $field = [
                'ad_limit' => [
                    'label' => trans('visiosoft.module.packages::field.create_ad_limit.name'),
                    'required' => true,
                    'value' => $settingRepository->value('visiosoft.module.advs::default_adv_limit'),
                    'min' => $settingRepository->value('visiosoft.module.advs::default_adv_limit'),
                    'type' => 'anomaly.field_type.integer',
                ],
                'time' => [
                    'label' => trans('visiosoft.module.packages::field.ad_publish_time.name'),
                    'required' => true,
                    'value' => $settingRepository->value('visiosoft.module.advs::default_published_time'),
                    'min' => $settingRepository->value('visiosoft.module.advs::default_published_time'),
                    'type' => 'anomaly.field_type.integer',
                ],
            ];
            $form->setFields(array_merge(['name', 'price', 'currency'], $field));
            if ($request->action == "save") {
                $form->skipField('ad_limit');
                $form->skipField('time');
                $form->render();
                $lastPackageByUser = $packageModel->getLastCreatePackageByUser();

                    $packageEntryModel->createEntry([
                        'package_id' => $lastPackageByUser->id,
                        'cat_id' => 0,
                        'ad_limit' => $request->ad_limit,
                        'time_limit' => $request->time,
                    ]);
                return redirect('admin/packages')->withSuccess([trans('visiosoft.module.packages::message.package_success_create')]);
            }
        } else {
            if ($request->action == "save") {
                $form->render();
                $entry = array();
                foreach ($request->all() as $index => $item) {
                    if (substr($index, 0, 4) == "time" or substr($index, 0, 7) == "adlimit") {
                        if (substr($index, 0, 4) == "time") {
                            $entry[substr($index, 4)]['time'] = $item;
                        } else {
                            $entry[substr($index, 7)]['ad_limit'] = $item;
                        }
                    }
                }
                $packageEntryModel->saveArray($entry);
                return redirect('admin/packages')->withSuccess([trans('visiosoft.module.packages::message.package_success_create')]);
            }
        }
        return $form->render();

    }
}
