<?php namespace Visiosoft\PackagesModule\User\Listener;

use Visiosoft\CartsModule\Cart\Event\CartRemove;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;

class RemovePackageCart
{
    /**
     * @var UserRepositoryInterface
     */
    private $userRepository;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(UserRepositoryInterface $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    public function handle(CartRemove $event)
    {
        $item = $event->getItem();
        if ($item->entry_type == "Visiosoft\PackagesModule\Package\PackageModel") {
            $this->userRepository->newQuery()->where('id', $event->saleItem->entry_id)->delete();
        }
    }
}
