<?php namespace Visiosoft\OrdersModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\OrdersModule\Order\Command\GetOrder;

class OrdersModulePlugin extends Plugin
{

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getOrder',
                function ($id) {

                    if (!$ad = $this->dispatch(new GetOrder($id))) {
                        return null;
                    }
                    return $ad;
                }
            )
        ];
    }
}
