<?php namespace Visiosoft\OrdersModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\OrdersModule\Events\OrderDelivered;
use Visiosoft\OrdersModule\Events\OrderNotDelivered;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Order\Table\OrderTableBuilder;
use Visiosoft\OrdersModule\Orderdetail\Event\AgainPurchaseOrder;
use Visiosoft\OrdersModule\Orderdetail\Event\AgainSaleOrder;
use Visiosoft\OrdersModule\Orderdetail\Event\ReportOrder;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailRepository;
use Visiosoft\OrdersModule\Orderpayment\OrderpaymentModel;

class OrderController extends PublicController
{
    private $adv_model;
    private $model;
    private $order_detail_model;
    private $order_detail_repository;
    private $order_payment_model;

    public function __construct(
        AdvModel $advModel,
        OrderModel $orderModel,
        OrderdetailModel $orderdetailModel,
        OrderdetailRepository $orderdetailRepository,
        OrderpaymentModel $orderpaymentModel
    )
    {
        $this->adv_model = $advModel;
        $this->model = $orderModel;
        $this->order_detail_model = $orderdetailModel;
        $this->order_detail_repository = $orderdetailRepository;
        $this->order_payment_model = $orderpaymentModel;
        parent::__construct();
    }

    public function sale(OrderTableBuilder $table)
    {
        $mySales = $this->order_detail_model->listMySales();
        foreach ($mySales as $index => $mySale) {
            if ($mySale->item_type == 'adv') {
                $mySales[$index]->detail_url = $this->adv_model->getAdvDetailLinkByAdId($mySale->item_id);
            }
            $mySales[$index]->detail_url = "#";
        }
        return $this->view->make('visiosoft.module.orders::sale/index', compact('mySales'));
    }

    public function saleDetail($id)
    {
        $details = $this->order_detail_model->getOrder($id);
        if ($details and $this->checkOwner($details)) {
            if ($details->item_type == "adv") {
                $details->detail_url = $this->adv_model->getAdvDetailLinkByAdId($details->item_id);
            } else {
                $details->detail_url = "#";
            }
            return $this->view->make('visiosoft.module.orders::sale/detail', compact('details'));
        }

        $this->messages->error(trans('visiosoft.module.orders::message.error_auth_detail'));
        return $this->redirect->to('/sale');
    }

    public function purchase()
    {
        if (request()->user && \auth()->user()->isAdmin()) {
            $userID = request()->user;
        } else {
            $userID = \auth()->id();
        }
        $myPurchase = $this->model->listMyOrders($userID);
        return $this->view->make('visiosoft.module.orders::purchase/index', compact('myPurchase'));
    }

    public function purchaseDetail($id)
    {
        cart_count(true);

        $purchase = $this->model->findMyOrder($id);
        if ($purchase) {
            $details = $this->order_detail_model->getDetail($id);
            foreach ($details as $index => $detail) {
                if ($detail->item_type == "adv") {
                    $details[$index]->detail_url = $this->adv_model->getAdvDetailLinkByAdId($detail->item_id);
                } elseif ($detail->item_type == "doping") {
                    $doping_repository = app(DopingRepositoryInterface::class);
                    $doping = $doping_repository->find($detail->item_id);
                    $details[$index]->detail_url = $this->adv_model->getAdvDetailLinkByAdId($doping->adv_name_id);
                } else {
                    $details[$index]->detail_url = "#";
                }
            }
            return $this->view->make('visiosoft.module.orders::purchase/detail', compact('details', 'purchase'));
        }
        $this->messages->error(trans('visiosoft.module.orders::message.error_auth_detail'));
        return $this->redirect->to('/purchase');
    }

    public function addTrackingNumber()
    {
        $order_detail_id = $this->request->id;
        $transport_number = $this->request->transportNumber;
        $transport_days = $this->request->transportDays;
        $transport_detail_url = $this->request->transport_detail_url;

        $this->order_detail_repository
            ->addTransportnumber($order_detail_id, $transport_number, $transport_days, $transport_detail_url);

        return $this->redirect->route('orders::sale_detail', ['id' => $order_detail_id]);
    }

    public function orderDelivered($id)
    {
        try {
            event(new OrderDelivered($id));

            $this->order_detail_model->setStatus($id, 'paid_buyer');
            $this->order_payment_model->addSalesPayment($id);
            return back()->with('success', ['Success']);
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
            return redirect()->back();
        }
    }

    public function orderNotDelivered($id)
    {
        $this->order_detail_model->setStatus($id, 'error_buyer');
        return back()->with('success', ['Success']);
    }

    public function reportSales()
    {
        if ($this->request->status == 'sendAgain') {
            $seller = Auth::user();
            $buyer = $this->order_detail_repository->getOrderUser($this->request->id);
            $this->order_detail_repository
                ->report($this->request->id, $this->request->reportContent, 'awaiting_tracking_number');

            $this->events->dispatch(new AgainPurchaseOrder($this->request->reportContent, $buyer));
            $this->events->dispatch(new AgainSaleOrder($this->request->reportContent, $seller));

//                $buyer->notify(new AgainPuchaseOrder($request->reportContent, $buyer['display_name']));/*notify*/
//                $seller->notify(new AgainSaleOrder($request->reportContent, $seller['display_name']));/*notify*/

        } else {
            $this->order_detail_repository->report($this->request->id, $this->request->reportContent);
            $user = $this->order_detail_repository->getOrderUser($this->request->id);
            $this->order_payment_model->addCancelPayment($this->request->id, $this->request->reportContent);

            $this->events->dispatch(new ReportOrder($this->request->reportContent, $user));
//                $user->notify(new ReportOrder($request->reportContent, $user['display_name']));/*notify*/

        }
        return back()->with('success', ['Success']);
    }

    public function checkOwner($order)
    {
        if ($order->item_type == "adv" and $ad = $this->adv_model->find($order->item_id)) {
            if ($ad->created_by_id == Auth::id()) {
                return true;
            }
        }
        return false;
    }

    public function paymentSuccessCustomer()
    {
        $order_id = $this->request->cookie('order_id');

        if($order = $this->model->newQuery()->find($order_id))
        {
            return $this->view->make('visiosoft.module.orders::customer/paymentSuccess',compact('order'));
        }
        abort(404);
    }

    public function purchaseCancel($id){
    	$order = new OrderModel();
    	$order->setStatus('canceled', $id);

    	return $this->purchase();
    }
}