<?php namespace Visiosoft\OrdersModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\OrdersModule\Seed\PaymentNameSeeder;

class OrdersModuleSeeder extends Seeder
{
    public function run()
    {
        // Payment Name Seeder
        $this->call(PaymentNameSeeder::class);

        if (is_module_installed('visiosoft.module.notifications')) {

            $template_repo = app(TemplateRepositoryInterface::class);
            if (!$template_repo->findBySlug('created_refund_notification_for_user')) {
                $template_repo->create([
                    'en' => [
                        'message' => '
                            <h1>Your Product Return Request Has Been Received</h1>
                            <p>Your return request has been received for your <a href="{ad_url}">{ad_name}</a> product.</p>
                            <p><a href="{order_url}">Show Order</a></p>
                        ',
                        'name' => 'Created Refund Notification for User',
                        'greeting' => 'Hello',
                        'subject' => 'Your Product Return Request Has Been Received'
                    ],
                    'slug' => 'created_refund_notification_for_user'
                ]);
            }

            if (!$template_repo->findBySlug('created_refund_notification_for_seller')) {
                $template_repo->create([
                    'en' => [
                        'message' => '
                            <h1>Your Product Return Request Has Been Received</h1>
                            <p>Your return request has been received for your <a href="{ad_url}">{ad_name}</a> product.</p>
                            <p><a href="{seller_order_url}">Show Order</a></p>
                        ',
                        'name' => 'Created Refund Notification for Seller',
                        'greeting' => 'Hello',
                        'subject' => 'Your Product Return Request Has Been Received!'
                    ],
                    'slug' => 'created_refund_notification_for_seller'
                ]);
            }

            if (!$template_repo->findBySlug('created_refund_notification_for_admin')) {
                $template_repo->create([
                    'en' => [
                        'message' => '
                            <h1>Return Request for {ad_name}</h1>
                            <p>A return request has been created for the <a href="{ad_url}">{ad_name}</a>.</p>
                            <p><a href="{admin_refund_url}">Show Refund Request</a></p>
                        ',
                        'name' => 'Created Refund Notification for Admin',
                        'greeting' => 'Hello',
                        'subject' => 'Return Request for {ad_name}'
                    ],
                    'slug' => 'created_refund_notification_for_admin'
                ]);
            }


            //Return Status Templates
            if (!$template_repo->findBySlug('refund_status_changed_for_user')) {
                $template_repo->create([
                    'en' => [
                        'message' => '
                            <h1>Your Product Return status has been concluded!</h1>
                            <p>Your return request for your <a href="{ad_url}">{ad_name}</a> product has been concluded.</p>
                            <p>{refund_message}</p>
                            <p><a href="{order_url}">Show Order</a></p>
                        ',
                        'name' => 'Refund Status Changed Notification for User',
                        'greeting' => 'Hello',
                        'subject' => 'Your Product Return status has been concluded!'
                    ],
                    'slug' => 'refund_status_changed_for_user'
                ]);
            }

            if (!$template_repo->findBySlug('refund_status_changed_for_seller')) {
                $template_repo->create([
                    'en' => [
                        'message' => '
                            <h1>The product return status has been changed.</h1>
                            <p>The return status for the <a href="{ad_url}">{ad_name}</a> product has been changed.</p>
                            <p>{refund_message}</p>
                            <p><a href="{seller_order_url}">Show Order</a></p>
                        ',
                        'name' => 'Refund Status Changed Notification for Seller',
                        'greeting' => 'Hello',
                        'subject' => 'The product return status has been changed!'
                    ],
                    'slug' => 'refund_status_changed_for_seller'
                ]);
            }

            if (!$template_repo->findBySlug('refund_status_changed_for_admin')) {
                $template_repo->create([
                    'en' => [
                        'message' => '
                            <h1>The product return status has been changed.</h1>
                            <p>The return status for the <a href="{ad_url}">{ad_name}</a> product has been changed.</p>
                            <p>{refund_message}</p>
                            <p><a href="{admin_refund_url}">Show Refund Request</a></p>
                        ',
                        'name' => 'Refund Status Changed Notification for Admin',
                        'greeting' => 'Hello',
                        'subject' => 'Changed Refund Request Status for {ad_name}'
                    ],
                    'slug' => 'refund_status_changed_for_admin'
                ]);
            }
        }
    }
}